
/****************************************************************************

PLXIO.H

Basic port I/O for a VxD.

Copyright PLX Technology, 1997

Changes
9702013	Ryan	Genesis - Basic port I/O for a VxD

****************************************************************************/

///////////////////////////////////////////////////////////////////////
#ifndef PLXIO_H
#define PLXIO_H

///////////////////////////////////////////////////////////////////////
void __inline
Outp(DWORD port, BYTE data)
{	// Output byte
	_asm mov edx, port
	_asm mov al, data
	_asm out dx, al
}

///////////////////////////////////////////////////////////////////////
void __inline
Outpd(DWORD port, DWORD data)
{	// Output dword
	_asm mov edx, port
	_asm mov eax, data
	_asm out dx, eax
}

///////////////////////////////////////////////////////////////////////
#pragma warning(disable:4035)
BYTE __inline
Inp(DWORD port)
{	//Input byte
	_asm mov edx, port
	_asm in al,dx
}
#pragma warning(default:4035)

///////////////////////////////////////////////////////////////////////
#pragma warning(disable:4035)
DWORD __inline
Inpd(DWORD port)
{	//Input dword
	_asm mov edx, port
	_asm in eax,dx
}
#pragma warning(default:4035)

#endif // PLXIO_H
///////////////////////////////////////////////////////////////////////
// End of file